function []=spawn_ACQUIRE(ip,filename,chans,rate,ds,n)
%function []=spawn_AQUIRE(ip,filename,chans,rate,ds,n)
% ip        - Text form of IP adress of target STM32F411 board
% filename  - Path/filename of file to save data in
% chans     - Channel list to acquire - 0 to 9 are pins 17 is 1.21V internal ref
% rate      - ADC sample rate for each channel
% ds        - Down sample rate for save in file - if ds>1 then low pass filter and time align channels
% n         - Number of sample frames to record in file
% acqdemo('192.168.1.4','testfile',[0:9 17],5000,2,5000,1e7)
% Ian Stothers May 2021

% Defaults
if(nargin<6) n=1e7; end;
if(nargin<5) ds=5; end;
if(nargin<4) rate=5000; end;
if(nargin<3) chans=[0 2 17]; end;
if(nargin<2) filename='testfile'; end;
if(nargin<1) ip='192.168.1.4'; end;


%acqdemo1(ip,filename,chans,rate,ds,n)
callstr1= ["acqdemo1("...
 sprintf("\'%s\',",ip)...
 sprintf("\'%s\',",filename)...
 "[" sprintf("%d,",chans) "],"...
 sprintf("%f,",rate)...
 sprintf("%d,",ds)...
 sprintf("%d);",n)...
 ];
 
octave_spawn(callstr1);

pause(1);
commandwindow (); % force focus back to coommand window - and activete? windows
%endfunction


  